%this script fits an arbitrary shape with DM influence functions
close all; clear all; clc;
%rand('seed',123);
limiting=0;
showIFs=0;

%load the DM configuration
dm = LoadDM('MDM1-32S-001.dm');
figure;
ShowDM(dm); axis image;

%load influnce functions
files=dir('outputIF*.txt');
PVdm = 10e-6;
Ddm = 25.4e-3;
wavelength = 0.633e-6;
dmScaleFactor=0.8;
figure;
for ii=1:length(files);
    IF{ii}=csvread(files(ii).name);
    nxy = min([size(IF{ii},1) size(IF{ii},2)]);
    IF{ii} = IF{ii}(1:nxy,1:nxy);
    if (ii==1)
        nxy = size(IF{1},1);
        dxy = Ddm/(nxy-4);
        x = (-nxy/2:1:nxy/2-1)*dxy;
    end;
    if (showIFs)
        clf;
        imagesc(x,x,IF{ii}); axis image; colorbar;
        title(ii); pause(0.001);
    end;
end;

%create a DM aperture and a fit aperture
[xx,yy]=meshgrid(x,x);
r = sqrt(xx.^2+yy.^2);
apDM = (r<=Ddm/2);
apFit = (r<=Ddm/2*dmScaleFactor);

%scale the DM IFs so that the sum of all of them is equal in amplitude to
%10 waves
dm = 0.0 .* IF{1};
for ii=1:length(IF); dm=dm+IF{ii}; end;
PV = max(max(dm)) - min(min(dm));
for ii=1:length(IF); IF{ii}=IF{ii}./PV.*PVdm; end;

%create a sample grid
nxySample = 14;
dxySample = Ddm/(nxySample);
xs=(-nxySample/2:1:nxySample/2-1)*dxySample;
[xxs,yys]=meshgrid(xs,xs);
rs=sqrt(xxs.^2+yys.^2);
rSample = rs(:);
xSample = xxs(:); ySample = yys(:);
ind = find(rSample<Ddm/2*dmScaleFactor);
xSample = xSample(ind);
ySample = ySample(ind);

%check if enough samples
if (length(xSample)<length(IF))
    error('Not enough samples for fitting');
end;

%show the sample grid on top of the first IF
figure;
imagesc(x,x,IF{1});
hold on;
plot(xSample,ySample,'r*');

%find the coordinates of samples
for ii=1:length(xSample)
    [mv,xi(ii)] = min(abs(x-xSample(ii)));
    [mv,yi(ii)] = min(abs(x-ySample(ii)));
end;

%sample the influence functions to create a poke matrix
for ii=1:length(IF)
    for jj=1:length(xi)
        poke(ii,jj) = IF{ii}(xi(jj),yi(jj));
    end;
end;
figure;
imagesc(poke); title('Poke Matrix');

%invert the poke matrix to create the control matrx
[u,ss,v]=svd(poke);
sv=diag(ss); gains=sv;
svi = 1.0./sv;
si = zeros(size(ss,2),size(ss,1));
%show the svd gains
figure; semilogy(sv,'*b-'); title('svd gains-AOA recon');

%remove some modes
modesRemoved = 0;
for ii=1:size(svi,1)-modesRemoved;
    si(ii,ii) = svi(ii);
end;
control=v*si*u';

%show the control matrix
figure; imagesc(control); title('Control');

%% create a phase screen
Dap = 30.0e-2;  Dap_over_r0=2;
r0 = Dap/Dap_over_r0;
nxy = 128; dxy = Dap/nxy;
xp = (-nxy/2:1:nxy/2-1)*dxy;
[xxp,yyp]=meshgrid(xp,xp);
rp = sqrt(xxp.^2+yyp.^2);
K = fftshift(rp);
PHIp = (0.023/r0.^(5/3)) .* K.^(-11/3);
PHIp(1,1)=0;
PHI = sqrt(PHIp) .* exp(j*2*pi*rand(nxy,nxy));
%figure; subplot(1,2,1); imagesc(abs(PHI)); colorbar; title('PHI');
%subplot(1,2,2); imagesc(angle(PHI)); colorbar; title('PHI');
phi = ifft2((PHI));
% figure('position',[360         278        1032         420]);
% subplot(1,2,1); imagesc(imag(phi)); colorbar; title('imag');
% subplot(1,2,2); imagesc(real(phi)); colorbar; title('real');
phase = real(phi) ./ (2*pi) .* wavelength;
figure; imagesc(xp,xp,phase); axis image; title('Phase (meters)'); colorbar;
hold on;
theta = 0:0.1:2.0*pi;
%xcircle = Ddm/2 * cos(theta); ycircle = Ddm/2 * sin(theta);
xcircle = Dap/2 * cos(theta); ycircle = Dap/2 * sin(theta);
plot(xcircle,ycircle,'r--','linewidth',2');

%% sample the desired shape with magnification
Magnification = Dap / Ddm;
shape = interp2(xp./Magnification,(xp./Magnification)',phase,x,(x)'); %interpolate onto the same grid
shape(find(isnan(shape)==1))=0;

%remove the mean over the fit aperture area
shapeFit = shape .* apFit;
shapeVec = shapeFit(:);
ind = find(shapeVec~=0);
shape = shape - mean(shapeVec(ind));
shape = shape .* apFit;

%sample it on the desired grid
for jj=1:length(xi)
    vec(jj) = shape(xi(jj),yi(jj));
end;

%fit to the desired shape
commands = control' * vec';
figure; bar(commands); title('Commands');

if (limiting)
    %implement limiting at -0.5 to 0.5
    c0 = commands;
    commands = c0 .* (c0>-0.5) + (c0<-0.5).*-0.5;
    commands = commands .* (c0<0.5) + (c0>0.5).*0.5;
    figure; bar([c0 commands c0-commands]); title('Limited Commands'); colormap(jet);
    legend('requested','limited','difference');
end;

%create the resulting DM shape
dm=0.0 .* IF{1};
for ii=1:length(IF); dm=dm+IF{ii}.*commands(ii); end;

%show the resulting DM shape
figure;
subplot(1,3,1); imagesc(x,x,shape .* apDM); axis image; colorbar; title('Desired Shape');
hold on; plot(x(xi),x(yi),'wo');
cax = caxis;
subplot(1,3,2); imagesc(x,x,dm); axis image; colorbar; title('DM Shape');
hold on; plot(x(xi),x(yi),'wo');
caxis(cax); colorbar;
subplot(1,3,3); imagesc(x,x,apFit .* (shape - dm)); axis image; colorbar; title('Difference');
hold on; plot(x(xi),x(yi),'wo');
caxis(cax); colorbar;

%calculate RMS wavefront error and estimated Strehl ratio
delta = apFit .* (shape - dm); 
dv=delta(:); ind = find(dv~=0); dvs = dv(ind); %look at all the non-zero elements in vector form
rmswfe_m=sqrt(sum((dvs-mean(dvs)).^2)/length(ind))
rmswfe_rads = rmswfe_m / wavelength * 2 * pi
SR = exp(-1.0 * (rmswfe_rads).^2)

%look at what the Strehl ratio would be without compensation
delta = apFit .* (shape); 
dv=delta(:); ind = find(dv~=0); dvs = dv(ind); %look at all the non-zero elements in vector form
rmswfe_m_uncomp=sqrt(sum((dvs-mean(dvs)).^2)/length(ind));
rmswfe_rads_uncomp = rmswfe_m_uncomp / wavelength * 2 * pi;
SR_uncomp = exp(-1.0 * (rmswfe_rads_uncomp).^2)
